<?php
/*
Template Name: Search Profiles
Template Post Type: page
*/
get_header();
?>
<main>
    <div class="wrapper_main">
        <div class="container">
            <div class="wrapper_content">
                <div class="title_wrapper title_wrapper_3">
                    <div>
                        <div class="icon_title">
                            <?php include locate_template('assets/img/tales_icon_6.svg'); ?>
                        </div>
                        <h2 class="title"><?php the_title() ?></h2>
                    </div>
                </div>
                <div class="wrapper_inner">
                    <div class="content_box">
                        <div class="module_box_info">
                            <div class="header_top header_top_auto box_shadow">
                                <div class="module_search module_search_result">
                                    <!--<form data-ajax="false" data-fill="#search-results" class="search-ajax-form">-->
                                    <form class="search-ajax-form" method="post">
                                        <input type="hidden" name="action" value="poker_search_profiles">
                                        <input type="text" name="poker_search" placeholder="Enter a Search Term. You can search using name, nickname or player ID.">
                                        <button>
                                            <?php include locate_template('assets/img/search_icon_art.svg'); ?>
                                        </button>
                                        <input type="submit" style="display: none;">
                                    </form>
                                </div>
                            </div>
                            <?php poker_search_profiles_handler_without_ajax();?>                           
                            <!-- <div class="wrapper_table">
                                <table class="main_table main_table_2 main_table_search">
                                    <thead>
                                        <tr>
                                            <td>Nickname</td>
                                            <td>Player ID</td>
                                            <td></td>
                                        </tr>
                                    </thead>
                                    <tbody id="search-results"></tbody>
                                </table>
                            </div>-->
                        </div>
                        <?php
                        get_template_part('template-parts/banner');
                        get_template_part('template-parts/member', 'card');
                        ?>
                    </div>
                    <?php get_sidebar() ?>
                </div>
            </div>
        </div>
    </div>
</main>

<?php get_footer() ?>